import refreshTokenHelper from "../../../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../../../utils/errorHandlingHelper"
import fetchHelper from "../../../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.basePriceListVersionId) {
    newObjValue = {...newObjValue, 
      M_Pricelist_Version_Base_ID: {
        id: body.basePriceListVersionId,
        tableName: 'M_Pricelist_Version'
      }
    }
  }
  if(body.discountSchemaId) {
    newObjValue = {...newObjValue, 
      M_DiscountSchema_ID: {
        id: body.discountSchemaId,
        tableName: 'M_DiscountSchema'
      }
    }
  }

  if(body.id) {
    const res: any = await fetchHelper(event, 'models/m_pricelist_version/'+body.id, 'PUT', token, {
      isActive: body.isActive,
      name: body.name,
      description: body.description,
      validFrom: body.validFrom,
      ...newObjValue,
      tableName: 'm_pricelist_version'
    })
    if(res) {
      data = res
      data['status'] = 200
      data['message'] = ''
    }
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})